#include <bits/stdc++.h>

using namespace std;

const int mxN = 5005;

vector<int> adj[mxN];

void solve() {
    int n, k;
    cin >> n >> k;

    for(int i = 0; i < n; ++i) {
        adj[i].clear();
    }

    for(int i = 1; i < n; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;

        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    const int INF = 1e9 + 12;

    auto nadji = [&](int s) {
        vector<int> dist(n, INF);
        dist[s] = 0;

        queue<int> q;
        q.push(s);

        while(!q.empty()) {
            auto tren = q.front();
            q.pop();

            for(auto e : adj[tren]) {
                if(dist[e] > dist[tren] + 1) {
                    dist[e] = dist[tren] + 1;
                    q.push(e);
                }
            }
        }

        auto it = max_element(dist.begin(), dist.end());
        return make_pair(*it, it - dist.begin());
    };

    vector<bool> marked(n);

    int root = nadji(0).second;

    int ans = 0;

    vector<int> rod(n);
    vector<int> dep(n);

    auto markiraj = [&](auto &self, int s, int p) -> void {
        rod[s] = p;
        if(p != -1) {
            dep[s] = dep[p] + 1;
        }
        for(auto e : adj[s]) {
            if(e == p) continue;
            self(self, e, s);
        }
    };

    markiraj(markiraj, root, -1);

    {
        int drugi = max_element(dep.begin(), dep.end()) - dep.begin();

        while(drugi != -1) {
            marked[drugi] = true;
            drugi = rod[drugi];
            if(drugi != -1) {
                ++ans;
            }
        }
    }

    for(int iter = 0; iter < k; ++iter) {
        if(ans == n - 1) break;
        vector<int> adj2[n];

        vector<int> kand;
        kand.reserve(n);

        for(int i = 0; i < n; ++i) {
            for(auto e : adj[i]) {
                if(!marked[e] && !marked[i]) {
                    adj2[i].push_back(e);
                }

                if(((marked[e] ^ marked[i])) && (!marked[i])) {
                    kand.push_back(i);
                }
            }
        }

        if(kand.empty()) break;

        vector<int> dist(n, INF);

        auto bfs = [&](int s) {
            queue<int> q;
            q.push(s);

            dist[s] = 0;

            pair<int, int> maksi{0, s};

            while(!q.empty()) {
                auto tren = q.front();
                q.pop();

                maksi = max(maksi, {dist[tren], tren});

                for(auto e : adj2[tren]) {
                    if(dist[e] > dist[tren] + 1) {
                        dist[e] = dist[tren] + 1;
                        q.push(e);
                    }
                }
            }

            return maksi;
        };

        vector<int> koji(n, -1);

        for(auto z : kand) {
            if(dist[z] != INF) continue;
            auto odg = bfs(z);
            koji[z] = odg.second;
        }
        
        vector<int> dist2(n, INF);
        vector<int> sa2(n, -1);

        auto bfs2 = [&](int s) {
            queue<int> q;
            q.push(s);

            dist2[s] = 0;

            pair<int, int> maksi{0, s};

            while(!q.empty()) {
                auto tren = q.front();
                q.pop();

                maksi = max(maksi, {dist2[tren], tren});

                for(auto e : adj2[tren]) {
                    if(dist2[e] > dist2[tren] + 1) {
                        sa2[e] = tren;
                        dist2[e] = dist2[tren] + 1;
                        q.push(e);
                    }
                }
            }

            return maksi;
        };

        pair<int, pair<int, int>> maksi{0, {-1, -1}};

        for(int i = 0; i < n; ++i) {
            if(koji[i] == -1) continue;
            auto odg = bfs2(koji[i]);
            maksi = max(maksi, {odg.first, {koji[i], odg.second}});
        }

        int trenutni = maksi.second.second;
        while(trenutni != -1 && !marked[trenutni]) {
            marked[trenutni] = true;
            ++ans;
            trenutni = sa2[trenutni];
        }
    }

    cout << ans << '\n';
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t;
    while(t--) solve();
}